/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.items.BaseChanceCubesItem;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.RewardsUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ItemSingleUseRewardSelectorPendant
extends BaseChanceCubesItem {
    public ItemSingleUseRewardSelectorPendant() {
        super(new Item.Properties().m_41487_(1), "single_use_reward_selector_pendant");
        super.addLore("Right click a Chance Cube to summon the reward.");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && level.m_5776_() && player.m_7500_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.openRewardSelectorGUI(player, stack));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player;
        if (context.m_43723_() == null || context.m_43723_().m_6047_()) {
            return InteractionResult.FAIL;
        }
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.PASS;
        }
        ServerLevel level = (ServerLevel)context.m_43725_();
        if (context.m_43722_().m_41783_() != null && context.m_43722_().m_41783_().m_128441_("Reward") && (player = context.m_43723_()) != null) {
            if (level.m_8055_(context.m_8083_()).m_60734_().equals((Object)CCubesBlocks.CHANCE_CUBE)) {
                level.m_46597_(context.m_8083_(), Blocks.f_50016_.m_49966_());
                IChanceCubeReward reward = GlobalCCRewardRegistry.DEFAULT.getRewardByName(context.m_43722_().m_41783_().m_128461_("Reward"));
                if (reward != null) {
                    GlobalCCRewardRegistry.triggerReward(reward, level, context.m_8083_(), context.m_43723_());
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    RewardsUtil.sendMessageToPlayer(player, "That reward does not exist for this cube!");
                }
            } else if (level.m_8055_(context.m_8083_()).m_60734_().equals((Object)CCubesBlocks.GIANT_CUBE)) {
                BlockEntity ent = level.m_7702_(context.m_8083_());
                if (!(ent instanceof TileGiantCube)) {
                    return InteractionResult.FAIL;
                }
                TileGiantCube giant = (TileGiantCube)ent;
                IChanceCubeReward reward = GlobalCCRewardRegistry.GIANT.getRewardByName(context.m_43722_().m_41783_().m_128461_("Reward"));
                if (reward != null) {
                    GlobalCCRewardRegistry.triggerReward(reward, level, giant.getMasterPostion(), context.m_43723_());
                    GiantCubeUtil.removeStructure(giant.getMasterPostion(), (Level)level);
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    RewardsUtil.sendMessageToPlayer(player, "That reward does not exist for this cube!");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

